import { PublicLayout } from "@/components/PublicLayout";
import { Link } from "wouter";
import { ShieldCheck, Fingerprint, ServerCrash, Network, Camera, ChevronRight } from "lucide-react";

export default function Services() {
  const services = [
    {
      id: "access-control",
      icon: Fingerprint,
      title: "Identity & Access Management",
      description: "Enterprise-grade biometric and RFID access control systems. Control who goes where, and exactly when, with absolute precision and immutable audit logs.",
      color: "text-primary"
    },
    {
      id: "cctv",
      icon: Camera,
      title: "CCTV & Visual Intelligence",
      description: "Next-generation visual surveillance grids. Utilizing edge-AI to detect anomalies, track movement, and provide crystal-clear 4K overwatch of your perimeter.",
      color: "text-secondary"
    },
    {
      id: "networking",
      icon: Network,
      title: "Hardened IT Networking",
      description: "Segmented, encrypted, and resilient network architectures designed to withstand targeted intrusion attempts while maintaining high-throughput operational capacity.",
      color: "text-emerald-500"
    }
  ];

  return (
    <PublicLayout>
      <div className="container mx-auto px-4 py-24">
        <div className="text-center max-w-3xl mx-auto mb-20">
          <h1 className="text-4xl md:text-5xl font-display font-bold mb-6">OPERATIONAL <span className="text-primary">CAPABILITIES</span></h1>
          <p className="text-lg text-muted-foreground">Comprehensive security deployments designed for high-risk, high-value environments.</p>
        </div>

        <div className="space-y-24">
          {services.map((service, idx) => (
            <div key={service.id} className={`flex flex-col md:flex-row gap-12 items-center ${idx % 2 !== 0 ? 'md:flex-row-reverse' : ''}`}>
              <div className="flex-1 w-full relative">
                {/* Abstract visualization instead of stock images for industrial tech vibe */}
                <div className="aspect-video rounded-2xl glass-panel overflow-hidden border border-white/10 flex items-center justify-center relative group">
                  <div className="absolute inset-0 bg-gradient-to-br from-black/80 to-transparent z-10" />
                  <div className="absolute inset-0 opacity-20 group-hover:opacity-40 transition-opacity bg-[radial-gradient(circle_at_center,_var(--tw-gradient-stops))] from-white/20 via-transparent to-transparent" />
                  <service.icon className={`w-32 h-32 ${service.color} opacity-80 z-20 transform group-hover:scale-110 transition-transform duration-500`} />
                  
                  {/* Decorative tech lines */}
                  <div className="absolute top-4 left-4 w-12 h-12 border-t-2 border-l-2 border-white/20" />
                  <div className="absolute bottom-4 right-4 w-12 h-12 border-b-2 border-r-2 border-white/20" />
                </div>
              </div>
              
              <div className="flex-1 space-y-6">
                <div className="inline-flex items-center gap-2 px-3 py-1 rounded-md bg-white/5 border border-white/10 text-xs font-display tracking-widest text-muted-foreground uppercase">
                  <ShieldCheck className="w-4 h-4" /> Service Module 0{idx + 1}
                </div>
                <h2 className="text-3xl font-display font-bold text-white">{service.title}</h2>
                <p className="text-lg text-muted-foreground leading-relaxed">{service.description}</p>
                
                <ul className="space-y-3 pt-4">
                  {[1, 2, 3].map((i) => (
                    <li key={i} className="flex items-center gap-3 text-sm font-medium">
                      <div className={`w-1.5 h-1.5 rounded-full bg-current ${service.color}`} />
                      System Specification Level {i}
                    </li>
                  ))}
                </ul>

                <div className="pt-6">
                  <Link href={`/contact?interest=${service.id}`} className={`inline-flex items-center gap-2 font-bold hover:gap-4 transition-all ${service.color}`}>
                    Request Deployment <ChevronRight className="w-5 h-5" />
                  </Link>
                </div>
              </div>
            </div>
          ))}
        </div>
      </div>
    </PublicLayout>
  );
}
