import { PublicLayout } from "@/components/PublicLayout";
import { Link } from "wouter";
import { Button } from "@/components/ui/button";
import { Shield, Lock, Server, ArrowRight } from "lucide-react";

export default function Home() {
  return (
    <PublicLayout>
      <div className="relative overflow-hidden">
        {/* Abstract Background Elements */}
        <div className="absolute inset-0 z-0">
          <div className="absolute top-0 left-1/4 w-[500px] h-[500px] bg-primary/20 rounded-full blur-[120px]" />
          <div className="absolute bottom-0 right-1/4 w-[600px] h-[600px] bg-secondary/10 rounded-full blur-[150px]" />
          <div className="absolute inset-0 bg-[url('data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSI0IiBoZWlnaHQ9IjQiPgo8cmVjdCB3aWR0aD0iNCIgaGVpZ2h0PSI0IiBmaWxsPSIjZmZmIiBmaWxsLW9wYWNpdHk9IjAuMDUiLz4KPC9zdmc+')] opacity-20" />
        </div>

        <div className="container mx-auto px-4 pt-32 pb-24 relative z-10">
          <div className="max-w-4xl mx-auto text-center space-y-8">
            <div className="inline-flex items-center gap-2 px-4 py-2 rounded-full border border-primary/30 bg-primary/10 text-primary mb-4 font-display text-sm tracking-widest">
              <span className="w-2 h-2 rounded-full bg-primary animate-pulse" />
              Military-Grade Protection
            </div>
            
            <h1 className="text-5xl md:text-7xl font-display font-black leading-tight text-white drop-shadow-[0_0_15px_rgba(249,115,22,0.3)]">
              SECURE YOUR <br />
              <span className="text-transparent bg-clip-text bg-gradient-to-r from-primary to-orange-300">INFRASTRUCTURE</span>
            </h1>
            
            <p className="text-xl text-muted-foreground max-w-2xl mx-auto leading-relaxed">
              Advanced access control, surveillance, and network security for enterprise facilities. We build the walls that protect your critical assets.
            </p>
            
            <div className="flex items-center justify-center gap-6 pt-8">
              <Link href="/contact" className="px-8 py-4 rounded-lg font-bold bg-primary text-primary-foreground hover:bg-primary/90 shadow-[0_0_20px_rgba(249,115,22,0.4)] hover:shadow-[0_0_30px_rgba(249,115,22,0.6)] transition-all flex items-center gap-2">
                Deploy Security <ArrowRight className="w-5 h-5" />
              </Link>
              <Link href="/services" className="px-8 py-4 rounded-lg font-bold border border-white/20 hover:bg-white/5 transition-all text-white">
                View Capabilities
              </Link>
            </div>
          </div>
        </div>

        <div className="container mx-auto px-4 pb-32 relative z-10">
          <div className="grid grid-cols-1 md:grid-cols-3 gap-8 mt-16">
            {[
              { icon: Lock, title: "Access Control", desc: "Biometric and smart-card entry systems with real-time logging." },
              { icon: Shield, title: "Surveillance", desc: "4K IP camera networks with AI-driven threat detection." },
              { icon: Server, title: "Network Security", desc: "Hardened IT infrastructure and encrypted communication channels." }
            ].map((feature, idx) => (
              <div key={idx} className="glass-panel p-8 rounded-2xl border-t border-white/10 hover:-translate-y-2 transition-transform duration-300 group">
                <div className="w-14 h-14 rounded-xl bg-secondary/20 flex items-center justify-center mb-6 border border-secondary/30 group-hover:bg-secondary/40 transition-colors">
                  <feature.icon className="w-7 h-7 text-secondary" />
                </div>
                <h3 className="text-xl font-display font-bold mb-3 text-white">{feature.title}</h3>
                <p className="text-muted-foreground">{feature.desc}</p>
              </div>
            ))}
          </div>
        </div>
      </div>
    </PublicLayout>
  );
}
