import { useMutation } from "@tanstack/react-query";
import { api } from "@shared/routes";

export function useExportDatabase() {
  return useMutation({
    mutationFn: async () => {
      const res = await fetch(api.system.export.path, { credentials: "include" });
      if (!res.ok) throw new Error("Export failed");
      
      const blob = await res.blob();
      const url = window.URL.createObjectURL(blob);
      const a = document.createElement('a');
      a.href = url;
      a.download = `system-export-${new Date().toISOString().split('T')[0]}.json`;
      document.body.appendChild(a);
      a.click();
      window.URL.revokeObjectURL(url);
      document.body.removeChild(a);
    },
  });
}
