import { Link } from "wouter";
import { ShieldCheck, Menu } from "lucide-react";
import { Button } from "@/components/ui/button";

export function PublicLayout({ children }: { children: React.ReactNode }) {
  return (
    <div className="min-h-screen flex flex-col bg-background">
      <header className="border-b border-white/10 glass-panel sticky top-0 z-50">
        <div className="container mx-auto px-4 h-20 flex items-center justify-between">
          <Link href="/" className="flex items-center gap-2 text-primary hover:text-primary/80 transition-colors">
            <ShieldCheck className="w-8 h-8" />
            <span className="font-display font-bold text-xl tracking-widest uppercase text-foreground">
              Aegis<span className="text-primary">Net</span>
            </span>
          </Link>
          
          <nav className="hidden md:flex items-center gap-8 font-sans font-medium text-sm">
            <Link href="/" className="text-muted-foreground hover:text-primary transition-colors">Home</Link>
            <Link href="/services" className="text-muted-foreground hover:text-primary transition-colors">Services</Link>
            <Link href="/contact" className="text-muted-foreground hover:text-primary transition-colors">Contact</Link>
            <div className="w-px h-6 bg-white/10" />
            <Link href="/login" className="text-muted-foreground hover:text-secondary transition-colors">Client Portal</Link>
          </nav>
          
          <Button variant="ghost" size="icon" className="md:hidden">
            <Menu className="w-6 h-6" />
          </Button>
        </div>
      </header>

      <main className="flex-1">
        {children}
      </main>

      <footer className="border-t border-white/10 bg-card py-12 mt-20">
        <div className="container mx-auto px-4 grid grid-cols-1 md:grid-cols-4 gap-8">
          <div className="space-y-4">
            <div className="flex items-center gap-2">
              <ShieldCheck className="w-6 h-6 text-primary" />
              <span className="font-display font-bold text-lg uppercase">AegisNet</span>
            </div>
            <p className="text-muted-foreground text-sm">Securing your digital and physical infrastructure with military-grade precision.</p>
          </div>
          <div>
            <h4 className="font-display font-bold mb-4 text-white">Solutions</h4>
            <ul className="space-y-2 text-sm text-muted-foreground">
              <li>Access Control</li>
              <li>Surveillance Systems</li>
              <li>Network Security</li>
            </ul>
          </div>
          <div>
            <h4 className="font-display font-bold mb-4 text-white">Company</h4>
            <ul className="space-y-2 text-sm text-muted-foreground">
              <li>About Us</li>
              <li>Careers</li>
              <li>Compliance</li>
            </ul>
          </div>
          <div>
            <h4 className="font-display font-bold mb-4 text-white">Connect</h4>
            <ul className="space-y-2 text-sm text-muted-foreground">
              <li>Emergency Support</li>
              <li>Contact Sales</li>
              <li>Client Portal</li>
            </ul>
          </div>
        </div>
        <div className="container mx-auto px-4 mt-12 pt-8 border-t border-white/5 text-center text-xs text-muted-foreground">
          © {new Date().getFullYear()} AegisNet Security Systems. All rights reserved.
        </div>
      </footer>
    </div>
  );
}
