import { Switch, Route } from "wouter";
import { queryClient } from "./lib/queryClient";
import { QueryClientProvider } from "@tanstack/react-query";
import { Toaster } from "@/components/ui/toaster";
import { TooltipProvider } from "@/components/ui/tooltip";
import NotFound from "@/pages/not-found";

// Public Pages
import Home from "./pages/Home";
import Services from "./pages/Services";
import Contact from "./pages/Contact";
import Login from "./pages/Login";

// Admin Pages
import Dashboard from "./pages/admin/Dashboard";
import Requests from "./pages/admin/Requests";
import Customers from "./pages/admin/Customers";
import Invoices from "./pages/admin/Invoices";
import InvoiceCreate from "./pages/admin/InvoiceCreate";
import Settings from "./pages/admin/Settings";

function Router() {
  return (
    <Switch>
      {/* Public Routes */}
      <Route path="/" component={Home}/>
      <Route path="/services" component={Services}/>
      <Route path="/contact" component={Contact}/>
      <Route path="/login" component={Login}/>
      
      {/* Admin Routes */}
      <Route path="/admin" component={Dashboard}/>
      <Route path="/admin/requests" component={Requests}/>
      <Route path="/admin/customers" component={Customers}/>
      <Route path="/admin/invoices" component={Invoices}/>
      <Route path="/admin/invoices/new" component={InvoiceCreate}/>
      <Route path="/admin/settings" component={Settings}/>
      
      {/* Fallback to 404 */}
      <Route component={NotFound} />
    </Switch>
  );
}

function App() {
  return (
    <QueryClientProvider client={queryClient}>
      <TooltipProvider>
        <Toaster />
        <Router />
      </TooltipProvider>
    </QueryClientProvider>
  );
}

export default App;
